<?php
// Adiciona o favicon no painel e personaliza a tela de login
require get_template_directory() . '/includes/customize-admin.php';

// Cria os campos no "Personalizar"
require get_template_directory() . '/includes/customizer.php';

// Remove acentuação dos arquivos no upload
add_filter('sanitize_file_name', 'remove_accents');

function provok_setup() {
	add_theme_support( 'title-tag' );

	add_theme_support( 'post-thumbnails' );
	add_image_size( 'slider', '9999', '9999', true );

	register_nav_menus( array(
		'menu-topo' => 'Menu Topo',
		'menu-rodape' => 'Menu Rodapé',
		'redes-sociais' => 'Redes Sociais',
	) );

	add_theme_support( 'custom-logo', array(
		'width' => 255,
		'height' => 73,
		'flex-width' => true,
		'header-text' => array( 'site-title' ),
	) );

	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
}
add_action( 'after_setup_theme', 'provok_setup' );

function provok_init_scripts() {
	// Arquivos CSS
	// wp_enqueue_style( 'style', get_template_directory_uri() . "/css/style.css" );
	// wp_enqueue_style( 'responsive', get_template_directory_uri() . "/css/responsive.css" );

	// Javascripts
	// wp_deregister_script( 'jquery' );
	// wp_enqueue_script( 'jquery', get_template_directory_uri() . "/js/jquery.min.js", array(), false, true );
	// wp_enqueue_script( 'bootstrap', get_template_directory_uri() . "/js/bootstrap.min.js", array( 'jquery' ), false, true );
	// wp_enqueue_script( 'scripts', get_template_directory_uri() . "/js/script.js", array( 'jquery' ), false, true );
}
add_action( 'wp_enqueue_scripts', 'provok_init_scripts', 11 );

function provok_document_title_separator( $separator ) {
	return '|';
}
add_filter( 'document_title_separator', 'provok_document_title_separator' );

add_action( 'init', 'create_post_type' );
function create_post_type() {
  register_post_type( 'palestras',
    array(
      'labels' 					=> array(
        'name' 					=> __( 'Palestras' ),
        'singular_name' 		=> __( 'Palestra' ),
        'add_new_item'  		=> __( 'Adicionar nova palestra'),
      ),
      'public' 					=> true,
      'menu_icon'  				=> 'dashicons-welcome-learn-more',
      'taxonomies'   			=> array( 'palestracat' ),
      'has_archive' 			=> true,
      'menu_position'         	=> 1,
	  'supports'		 		=> array('thumbnail','title', 'excerpt', 'editor')
    )
  );
}

//Quando der problema no post type acionar esta função
flush_rewrite_rules();

// Adicionando Taxonomias
add_action( 'init', 'custom_taxonomy', 0 );

function custom_taxonomy() {
	// categoria palestra
	$labels_mob = array(
		'name'                       => _x( 'Categoria da palestra', 'Taxonomy General Name', 'text_domain' ),
		'singular_name'              => _x( 'Categoria da palestra', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name'                  => __( 'Categoria da palestra', 'text_domain' )
	);
	$args_palestra = array(
		'hierarchical' => true,
		'labels'                     => $labels_mob,
		'show_ui' => true,
		'public'                     => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
	);
	register_taxonomy('palestracat', array('palestra') , $args_palestra);
}