<?php
/*
* Template Name: Home
*/
?>

<?php get_header(); ?>


<?php
  $slider = CFS()->get( 'slider' );
  if ( count( $slider ) ) {
?>
  <div id="carousel-home" class="carousel carousel-fade" data-ride="carousel">
    <ul class="carousel-indicators">
      <?php $i = 0; foreach ( $slider as $slide ) { ?>
        <li data-target="#carousel-home" data-slide-to="<?php echo $i; ?>" class="<?php if ($i == 0) {echo "active";} ?>"></li>
      <?php $i++; } ?>  
    </ul>
    <div class="carousel-inner">

      <?php $i = 0; foreach ( $slider as $slide ) { ?>
        <div class="carousel-item <?php if ($i == 0) {echo "active";} ?>" style="background-image: url(<?php echo $slide['imagem']; ?>);">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <img src="<?php bloginfo( 'template_url' ); ?>/img/banner-height.jpg" class="img-height">
                <div class="carousel-text">
                  <h1><?php echo $slide['titulo']; ?></h1>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php $i++; } ?>

    </div>
  </div>
<?php 
  } 
?>


  <div class="diferenciais">
    <div class="container">
      <div class="row">
        <div class="col-md-4">
          <div class="box-icon-text foo-1">
            <div class="box-icon-text-icon">
              <img src="<?php echo CFS()->get( 'imagem_box_icone_1' ); ?>" class="img-responsive" alt="Instigamos o que seu negócio">
            </div>
            <h3><?php echo CFS()->get( 'titulo_box_icone_1' ); ?></h3>
            <p><?php echo CFS()->get( 'descricao_box_icon_1' ); ?></p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="box-icon-text foo-2">
            <div class="box-icon-text-icon">
              <img src="<?php echo CFS()->get( 'imagem_box_icone_2' ); ?>" class="img-responsive" alt="Instigamos o que seu negócio">
            </div>
            <h3><?php echo CFS()->get( 'titulo_box_icone_2' ); ?></h3>
            <p><?php echo CFS()->get( 'descricao_box_icon_2' ); ?></p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="box-icon-text foo-3">
            <div class="box-icon-text-icon">
              <img src="<?php echo CFS()->get( 'imagem_box_icone_3' ); ?>" class="img-responsive" alt="Instigamos o que seu negócio">
            </div>
            <h3><?php echo CFS()->get( 'titulo_box_icone_3' ); ?></h3>
            <p><?php echo CFS()->get( 'descricao_box_icon_3' ); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="box-palestras">
    <div class="container">
      <h2><?php echo CFS()->get( 'titulo_palestras' ); ?></h2>
      <p><?php echo CFS()->get( 'subtitulo_palestras' ); ?></p>
      <div class="row">

        <?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;  $args = array('post_type'=>'palestras','posts_per_page' => 3, 'paged' => $paged ); query_posts($args); ?>

        <?php while(have_posts()): the_post(); ?>
        <?php
        $terms = get_the_terms($post->ID,'palestracat');
        ?>
        <div class="col-md-4">
          <div class="card foo-4">
            <div class="card-header">
              <img class="card-img-top" src="<?php $img = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium'); echo $img[0]; ?>" alt="">
                <span><?php echo $terms[0]->name; ?></span>
            </div>
            <div class="card-body">
              <h4 class="card-title"><?php the_title(); ?></h4>
              <p class="card-text"><?php the_excerpt(); ?></p>
              <div class="row row-btn-card">
                <div class="col-lg-7 col-md-12 col-sm-8">
                  <a href="<?php the_permalink(); ?>" class="btn btn-info btn-block text-uppercase"><b>Saiba mais</b></a>
                </div>
              </div>
            </div>
          </div>
        </div>

        <?php endwhile; wp_reset_query(); ?>
        
      </div> 
      <div class="row justify-content-center">
        <div class="col-md-4">
          <a href="/palestras" class="btn btn-light btn-block text-uppercase foo-5"><b>Ver mais palestras</b></a>
        </div>
      </div>
    </div>
  </div>

  <div class="box-coaching">
    <div class="container">
      <div class="row">
        <div class="col-md-6">
          <img src="<?php echo CFS()->get( 'imagem_coaching' ); ?>" class="img-responsive foo-4" style="margin-bottom: 30px;">
        </div>
        <div class="col-md-6 foo-6">
          <h2><?php echo CFS()->get( 'titulo_coaching' ); ?></h2>
          <p><?php echo CFS()->get( 'subtitulo_coaching' ); ?></p>
          <div class="row" style="margin-top: 40px;">
            <div class="col-md-4">
              <a href="<?php echo CFS()->get( 'link_coaching' ); ?>" class="btn btn-info btn-block text-uppercase"><b>Saiba mais</b></a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="box-news">
    <div class="container">
      <div class="text-center foo-1">
        <h2><?php echo CFS()->get( 'titulo_cadastro_ebook' ); ?></h2>
      </div>
      <div class="foo-1">
        <?php echo do_shortcode(CFS()->get( 'shortcode_cadastro_ebook' )); ?>
      </div>
      <!-- <form>
        <div class="row justify-content-center foo-1">
          <div class="col-md-3">
            <div class="form-group">
              <label>NOME:</label>
              <input type="text" class="form-control">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>E-MAIL:</label>
              <input type="text" class="form-control">
            </div>
          </div>
          <div class="col-md-2">
            <div class="form-group">
              <label>&nbsp;</label>
              <button type="submit" class="btn btn-info btn-block text-uppercase"><b>Cadastre-se</b></button>
            </div>
          </div>
        </div>
      </form> -->
    </div>
  </div>

  <div style="margin-bottom: 100px;"></div>

<?php get_footer(); ?>