<?php
/* 
Template Name: Palestras
*/
?>

<?php get_header('interna'); ?>
  <div class="arquive-palestras">
    <div class="container">
      <div class="row">
        <div class="col-md-8">
          <h1 class="text-uppercase">Palestras, Workshops e Visitas Técnicas</h1>
          <p><?php ptad_the_post_type_description(); ?></p>
          <div style="margin-bottom: 35px;"></div>
        </div>
        <div class="col-md-4">
          <div class="form-group" style="margin-top: 5px;">
            <select class="form-control filter">
              <option value="all">Filtrar as palestras por...</option>
                <?php 
                    $terms = get_terms( array(
                        'taxonomy' => 'palestracat',
                        'hide_empty' => false,
                    ));
                    foreach ($terms as $term) : 
                ?>
              <option value="<?php echo $term->slug; ?>"><?php echo $term->name; ?></option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>
      </div>
      <div class="box-palestras">
        <div class="row">

        <?php while(have_posts()): the_post(); ?>
        <?php
        $terms = get_the_terms($post->ID,'palestracat');
        ?>
        <div class="col-md-4 col-card <?php echo $terms[0]->slug; ?>">
          <div class="card foo-4">
            <div class="card-header">
              <img class="card-img-top" src="<?php $img = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium'); echo $img[0]; ?>" alt="Precificação">
              <span><?php echo $terms[0]->name; ?></span>
            </div>
            <div class="card-body">
              <h4 class="card-title"><?php the_title(); ?></h4>
              <p class="card-text"><?php the_excerpt(); ?></p>
              <div class="row row-btn-card">
                <div class="col-lg-7 col-md-12 col-sm-8">
                  <a href="<?php the_permalink(); ?>" class="btn btn-info btn-block text-uppercase"><b>Saiba mais</b></a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php endwhile; wp_reset_query(); ?>

        </div> 
      </div>
    </div>
  </div>

<?php get_footer(); ?>