<?php
/**
* Setup basico do tema
**/
function setup(){
  add_theme_support( 'post-thumbnails' );
  register_nav_menus( array(
    'primary' => __( 'Primary Menu',      'twentyfifteen' ),
    'social'  => __( 'Social Links Menu', 'twentyfifteen' ),
  ));
}
add_action( 'after_setup_theme', 'setup' );

/**
* Setup scripts do tema
**/
function scripts()
{
  wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css' );
  wp_enqueue_style( 'style', get_template_directory_uri() . '/css/index.css' );

  wp_enqueue_script( 'jquery', get_template_directory_uri() . '/js/jquery.min.js', array(), false, true );
  wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array(), false, true );
  wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/index.js', array(), false, true );
}
add_action( 'wp_enqueue_scripts', 'scripts' );

function create_post_types()
{
  register_post_type( 'banners',
    array(
      'labels' => array(
        'name' => __( 'Banners' ),
        'singular_name' => __( 'Banner' ),
        'add_new_item'  => __( 'Adicionar novo banner'),
      ),
      'public' => true,
      'has_archive' => true,
      'menu_position'         => 1,
      'supports' => array('title','thumbnail','editor')
    )
  );
}
add_action( 'init', 'create_post_types' );
